<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * Strings for component 'glossary', language 'en', branch 'MOODLE_20_STABLE'
 *
 * @package mod_glossary
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

$string['addcomment'] = 'Add comment';
$string['addcategory'] = 'Add category';
$string['addentry'] = 'Add a new entry';
$string['addsingleentry'] = 'Add entry';
$string['addingcomment'] = 'Add a comment';
$string['alias'] = 'Keyword';
$string['aliases'] = 'Keyword(s)';
$string['aliases_help'] = 'Each glossary entry can have an associated list of keywords (or aliases). If the entry is auto-linked, then any keywords will also be auto-linked.

Enter each keyword on a new line (not separated by commas).';
$string['allcategories'] = 'All categories';
$string['allentries'] = 'ALL';
$string['allowcomments'] = 'Allow comments on entries';
$string['allowcomments_help'] = 'If enabled, all participants with permission to create comments will be able to add comments to glossary entries.';
$string['allowduplicatedentries'] = 'Duplicate entries allowed';
$string['allowduplicatedentries_help'] = 'If enabled, multiple entries can have the same concept name.';
$string['allowprintview'] = 'Allow print view';
$string['allowprintview_help'] = 'If enabled, students are provided with a link to a printer-friendly version of the glossary. The link is always available to teachers.';
$string['andmorenewentries'] = 'and {$a} more new entries.';
$string['answer'] = 'Answer';
$string['approve'] = 'Approve';
$string['approvaldisplayformat'] = 'Approval display format';
$string['approvaldisplayformat_help'] = 'When approving glossary items you may wish to use a different display format';
$string['areaattachment'] = 'Attachments';
$string['areaentry'] = 'Definitions';
$string['areyousuredelete'] = 'Are you sure you want to delete this entry?';
$string['areyousuredeletecomment'] = 'Are you sure you want to delete this comment?';
$string['areyousureexport'] = 'Are you sure you want to export this entry to';
$string['ascending'] = 'ascending';
$string['attachment'] = 'Attachment';
$string['attachment_help'] = 'You can optionally attach one or more files to a glossary entry.';
$string['author'] = 'author';
$string['authorview'] = 'Browse by Author';
$string['back'] = 'Back';
$string['cachedef_concepts'] = 'Concept linking';
$string['cantinsertcat'] = 'Can\'t insert category';
$string['cantinsertrec'] = 'Can\'t insert record';
$string['cantinsertrel'] = 'Can\'t insert relation category-entry';
$string['casesensitive'] = 'This entry is case sensitive';
$string['casesensitive_help'] = 'This setting specifies whether matching exact upper and lower case is necessary when auto-linking to an entry.';
$string['cat'] = 'cat';
$string['categories'] = 'Categories';
$string['category'] = 'Category';
$string['categorydeleted'] = 'Category deleted';
$string['categoryview'] = 'Browse by category';
$string['cnfallowcomments'] = 'Define if a glossary will accept comments on entries by default';
$string['cnfallowdupentries'] = 'Define if a glossary will allows duplicated entries by default';
$string['cnfapprovalstatus'] = 'Define the approval status by default of an entry posted by a student';
$string['cnfcasesensitive'] = 'Define if an entry, when linked, is case sensitive by default';
$string['cnfdefaulthook'] = 'Select the default selection to show when the glossary is first viewed';
$string['cnfdefaultmode'] = 'Select the default frame to show when the glossary is first viewed.';
$string['cnffullmatch'] = 'Define if an entry, when linked, should match the case in the target text by default';
$string['cnflinkentry'] = 'Define if an entry should be automatically linked by default';
$string['cnflinkglossaries'] = 'Define if a glossary should be automatically linked by default';
$string['cnfrelatedview'] = 'Select the display format to be used for automatic linking and entry view.';
$string['cnfshowgroup'] = 'Specify if the group break should be shown or not.';
$string['cnfsortkey'] = 'Select the sorting key by default.';
$string['cnfsortorder'] = 'Select the sorting order by default.';
$string['cnfstudentcanpost'] = 'Define if the students can or cannot post entries by default';
$string['cnftabs'] = 'Select visible tabs for this glossary format';
$string['comment'] = 'Comment';
$string['commentdeleted'] = 'The comment has been deleted.';
$string['comments'] = 'Comments';
$string['commentson'] = 'Comments on';
$string['commentupdated'] = 'The comment has been updated.';
$string['completiondetail:entries'] = 'Make entries: {$a}';
$string['completionentries'] = 'Add entries';
$string['completionentriesdesc'] = 'Student must create at least {$a} entry/entries';
$string['concept'] = 'Concept';
$string['concepts'] = 'Concepts';
$string['configenablerssfeeds'] = 'This switch will enable the possibility of RSS feeds for all glossaries.  You will still need to turn feeds on manually in the settings for each glossary.';
$string['current'] = 'Currently sorted {$a}';
$string['currentglossary'] = 'Current glossary';
$string['date'] = 'date';
$string['dateview'] = 'Browse by date';
$string['defaultapproval'] = 'Approved by default';
$string['defaultapproval_help'] = 'If set to no, entries require approving by a teacher before they are viewable by everyone.';
$string['defaulthook'] = 'Default hook';
$string['defaultmode'] = 'Default mode';
$string['defaultsortkey'] = 'Default sort key';
$string['defaultsortorder'] = 'Default sort order';
$string['definition'] = 'Definition';
$string['definitions'] = 'Definitions';
$string['deleteentry'] = 'Delete entry';
$string['deletecategory'] = 'Delete category';
$string['deleteentrya'] = 'Delete entry: {$a}';
$string['deletenotenrolled'] = 'Entries by users not enrolled';
$string['deletingcomment'] = 'Deleting comment';
$string['deletingnoneemptycategory'] = 'Deleting this category will not delete the entries it contains - they will be marked as uncategorised.';
$string['descending'] = 'descending';
$string['destination'] = 'Destination of imported entries';
$string['destination_help'] = 'Entries can either be imported and added to the current glossary or to a new glossary, in which case a new glossary will be created based on information in the XML file.';
$string['disapprove'] = 'Undo approval';
$string['displayformat'] = 'Display format';
$string['displayformat_help'] = 'There are 7 display formats:

* Simple, dictionary style - No authors are displayed and attachments are shown as links
* Continuous without author - Entries are displayed one after another without any separation apart from the editing icons
* Full with author - A forum-like display format showing the author\'s data and with attachments shown as links
* Full without author - A forum-like display format without authors and with attachments shown as links
* Encyclopedia - As for "Full with author" but attached images are shown inline
* Entry list - Concepts are listed as links
* FAQ - The words QUESTION and ANSWER are appended to the concept and definition respectively';
$string['displayformatcontinuous'] = 'Continuous without author';
$string['displayformatdefault'] = 'Default to same as display format';
$string['displayformatdictionary'] = 'Simple, dictionary style';
$string['displayformatencyclopedia'] = 'Encyclopedia';
$string['displayformatentrylist'] = 'Entry list';
$string['displayformatfaq'] = 'FAQ';
$string['displayformatfullwithauthor'] = 'Full with author';
$string['displayformatfullwithoutauthor'] = 'Full without author';
$string['displayformats'] = 'Display formats';
$string['displayformatssetup'] = 'Display formats setup';
$string['duplicatecategory'] = 'Duplicate category';
$string['duplicateentry'] = 'Duplicate entry';
$string['editalways'] = 'Always allow editing';
$string['editalways_help'] = 'This setting specifies whether entries are always editable or whether students can only edit their entries during a configured editing time (usually 30 minutes).';
$string['editcategories'] = 'Edit categories';
$string['editcategory'] = 'Edit category';
$string['editentry'] = 'Edit entry';
$string['editentrya'] = 'Edit entry: {$a}';
$string['editingcomment'] = 'Editing comment';
$string['entbypage'] = 'Entries shown per page';
$string['entries'] = 'Entries';
$string['entrieswithoutcategory'] = 'Entries without category';
$string['entry'] = 'Entry';
$string['entryalreadyexist'] = 'Entry already exists';
$string['entryapproved'] = 'This entry has been approved';
$string['entrydeleted'] = 'Entry deleted';
$string['entryexported'] = 'Entry successfully exported';
$string['entryishidden'] = '(this entry is currently hidden)';
$string['entryleveldefaultsettings'] = 'Entry level default settings';
$string['entrylink'] = 'Entry link: {$a}';
$string['entrysaved'] = 'This entry has been saved';
$string['entryupdated'] = 'This entry has been updated';
$string['entryusedynalink'] = 'This entry should be automatically linked';
$string['entryusedynalink_help'] = 'If site-wide glossary auto-linking has been enabled by an administrator and this checkbox is ticked, the entry will be automatically linked wherever the concept words and phrases appear throughout the rest of the course.';
$string['errcannoteditothers'] = 'You cannot edit other people\'s entries.';
$string['errconceptalreadyexists'] = 'This concept already exists. No duplicates allowed in this glossary.';
$string['errdeltimeexpired'] = 'You can\'t delete this. Time expired!';
$string['erredittimeexpired'] = 'The editing time for this entry has expired.';
$string['errorparsingxml'] = 'Errors occurred while parsing the file. Make sure it is valid XML syntax.';
$string['errreservedkeywords'] = 'One or more keywords contain a special character which cannot be used.';
$string['eventcategorycreated'] = 'Category has been created';
$string['eventcategorydeleted'] = 'Category has been deleted';
$string['eventcategoryupdated'] = 'Category has been updated';
$string['evententryapproved'] = 'Entry has been approved';
$string['evententrycreated'] = 'Entry has been created';
$string['evententrydeleted'] = 'Entry has been deleted';
$string['evententrydisapproved'] = 'Entry has been disapproved';
$string['evententryviewed'] = 'Entry has been viewed';
$string['evententryupdated'] = 'Entry has been updated';
$string['explainaddentry'] = 'Add a new entry to the current glossary.<br />Concept and definition are mandatory fields.';
$string['explainall'] = 'Shows ALL entries on one page';
$string['explainalphabet'] = 'Browse the glossary using this index';
$string['explainexport'] = 'Click on the button below to export glossary entries.<br />You can import it anytime you wish in this or other course.<p>Please note that attachments (e.g. images) and authors are not exported.</p>';
$string['explainimport'] = 'You must specify the file to import and define the criteria of the process.<p>Submit your request and review the results.</p>';
$string['explainspecial'] = 'Shows entries that do not begin with a letter';
$string['export'] = 'Export';
$string['exportedentry'] = 'Exported entry';
$string['exportentries'] = 'Export entries';
$string['exportentriestoxml'] = 'Export entries to XML file';
$string['exportfile'] = 'Export entries to file';
$string['exportglossary'] = 'Export glossary';
$string['exporttomainglossary'] = 'Export to main glossary';
$string['filetoimport'] = 'File to import';
$string['filetoimport_help'] = 'Browse for and select the XML file on your computer which contains the entries to import.';
$string['fillfields'] = 'Concept and definition are mandatory fields.';
$string['filtername'] = 'Glossary auto-linking';
$string['fullmatch'] = 'Match whole words only';
$string['fullmatch_help'] = 'This setting specifies whether only whole words will be linked, for example, a glossary entry named "construct" will not create a link inside the word "constructivism".';
$string['glossary:addinstance'] = 'Add a new glossary';
$string['glossary:approve'] = 'Approve and undo approved entries';
$string['glossary:comment'] = 'Create comments';
$string['glossary:export'] = 'Export entries';
$string['glossary:exportentry'] = 'Export single entry';
$string['glossary:exportownentry'] = 'Export single entry of yours';
$string['glossary:import'] = 'Import entries';
$string['glossaryleveldefaultsettings'] = 'Glossary level default settings';
$string['glossary:managecategories'] = 'Manage categories';
$string['glossary:managecomments'] = 'Manage comments';
$string['glossary:manageentries'] = 'Manage entries';
$string['glossary:rate'] = 'Rate entries';
$string['glossary:view'] = 'View entries';
$string['glossarytype'] = 'Glossary type';
$string['glossarytype_help'] = 'A main glossary is a glossary in which entries from secondary glossaries can be imported. There can only be one main glossary in a course. If glossary entry import is not required, all glossaries in the course can be secondary glossaries.';
$string['glossary:view'] = 'View glossary';
$string['glossary:viewallratings'] = 'View all raw ratings given by individuals';
$string['glossary:viewanyrating'] = 'View total ratings that anyone received';
$string['glossary:viewrating'] = 'View the total rating you received';
$string['glossary:write'] = 'Create new entries';
$string['guestnoedit'] = 'Guests are not allowed to edit glossaries';
$string['changeto'] = 'change to {$a}';
$string['importcategories'] = 'Import categories';
$string['importedcategories'] = 'Imported categories';
$string['importedentries'] = 'Imported entries';
$string['importentries'] = 'Import entries';
$string['importentriesfromxml'] = 'Import entries from XML file';
$string['includegroupbreaks'] = 'Include group breaks';
$string['indicator:cognitivedepth'] = 'Glossary cognitive';
$string['indicator:cognitivedepth_help'] = 'This indicator is based on the cognitive depth reached by the student in a Glossary activity.';
$string['indicator:cognitivedepthdef'] = 'Glossary cognitive';
$string['indicator:cognitivedepthdef_help'] = 'The participant has reached this percentage of the cognitive engagement offered by the Glossary activities during this analysis interval (Levels = No view, View, Submit)';
$string['indicator:cognitivedepthdef_link'] = 'Learning_analytics_indicators#Cognitive_depth';
$string['indicator:socialbreadth'] = 'Glossary social';
$string['indicator:socialbreadth_help'] = 'This indicator is based on the social breadth reached by the student in a Glossary activity.';
$string['indicator:socialbreadthdef'] = 'Glossary social';
$string['indicator:socialbreadthdef_help'] = 'The participant has reached this percentage of the social engagement offered by the Glossary activities during this analysis interval (Levels = No participation, Participant alone)';
$string['indicator:socialbreadthdef_link'] = 'Learning_analytics_indicators#Social_breadth';
$string['isglobal'] = 'Is this glossary global?';
$string['isglobal_help'] = 'A global glossary has entries which are linked to from throughout the site, rather than only in the course that the glossary is in. Only administrators can set a glossary as global.';
$string['letter'] = 'letter';
$string['linkcategory'] = 'Automatically link this category';
$string['linkcategory_help'] = 'If glossary auto-linking has been enabled and this setting is enabled, the category name will be automatically linked wherever it appears throughout the rest of the course. When a participant follows a category name link, they will be taken to the "Browse by category" page of the glossary.';
$string['linking'] = 'Auto-linking';
$string['mainglossary'] = 'Main glossary';
$string['maxtimehaspassed'] = 'Sorry, but the maximum time for editing this comment ({$a}) has passed!';
$string['modulename'] = 'Glossary';
$string['modulename_help'] = 'The glossary activity module enables participants to create and maintain a list of definitions, like a dictionary, or to collect and organise resources or information.

A teacher can allow files to be attached to glossary entries. Attached images are displayed in the entry. Entries can be searched or browsed alphabetically or by category, date or author. Entries can be approved by default or require approval by a teacher before they are viewable by everyone.

If the glossary auto-linking filter is enabled, entries will be automatically linked where the concept words and/or phrases appear within the course.

A teacher can allow comments on entries. Entries can also be rated by teachers or students (peer evaluation). Ratings can be aggregated to form a final grade which is recorded in the gradebook.

Glossaries have many uses, such as

* A collaborative bank of key terms
* A ‘getting to know you’ space where new students add their name and personal details
* A ‘handy tips’ resource of best practice in a practical subject
* A sharing area of useful videos, images or sound files
* A revision resource of facts to remember';
$string['modulename_link'] = 'mod/glossary/view';
$string['modulenameplural'] = 'Glossaries';
$string['newentries'] = 'New glossary entries';
$string['newglossary'] = 'New glossary';
$string['newglossarycreated'] = 'New glossary created.';
$string['newglossaryentries'] = 'New glossary entries:';
$string['nocomment'] = 'No comment found';
$string['nocomments'] = '(No comments found on this entry)';
$string['noconceptfound'] = 'No concept or definition found.';
$string['noentries'] = 'No entries found in this section';
$string['noentry'] = 'No entry found.';
$string['nopermissiontodelcomment'] = 'You can\'t delete other people\'s comments!';
$string['nopermissiontodelinglossary'] = 'You can\'t comments in this glossary!';
$string['nopermissiontoviewresult'] = 'You can only look at results for your own entries';
$string['notcategorised'] = 'Not categorised';
$string['notapproved'] = 'glossary entry is not approved yet.';
$string['entrynotapproved'] = 'Entry not approved';
$string['numberofentries'] = 'Number of entries';
$string['onebyline'] = '(one per line)';
$string['page-mod-glossary-x'] = 'Any glossary module page';
$string['page-mod-glossary-edit'] = 'Glossary add/edit entry page';
$string['page-mod-glossary-view'] = 'View glossary edit page';
$string['pendingapproval'] = 'Pending approval';
$string['pendingapprovalcount'] = 'Pending approval ({$a})';
$string['pluginadministration'] = 'Glossary administration';
$string['pluginname'] = 'Glossary';
$string['popupformat'] = 'Popup format';
$string['print'] = 'Print';
$string['printerfriendly'] = 'Printer-friendly version';
$string['printviewnotallowed'] = 'Print view isn\'t allowed';
$string['privacy'] = 'Privacy of results';
$string['privacy:metadata:core_comments'] = 'Comments made on glossary definitions are stored using core_comment system';
$string['privacy:metadata:core_files'] = 'Files linked to glossary definitions are stored using the core_files system';
$string['privacy:metadata:core_rating'] = 'Ratings added to glossary entries are stored using core_rating system';
$string['privacy:metadata:core_tag'] = 'Tags added to glossary definitions are stored using core_tag system ';
$string['privacy:metadata:glossary_entries'] = 'Information about the user\'s entries for a given glossary activity';
$string['privacy:metadata:glossary_entries:attachment'] = 'The attachment of the entry the user added';
$string['privacy:metadata:glossary_entries:concept'] = 'The concept of the entry the user added';
$string['privacy:metadata:glossary_entries:definition'] = 'The definition of the entry the user added';
$string['privacy:metadata:glossary_entries:glossaryid'] = 'The ID of the glossary activity';
$string['privacy:metadata:glossary_entries:userid'] = 'The ID of the user that is adding this glossary entry';
$string['privacy:metadata:glossary_entries:timemodified'] = 'The timestamp indicating when the glossary entry was modified by the user';
$string['question'] = 'Question';
$string['rejectedentries'] = 'Rejected entries';
$string['rejectionrpt'] = 'Rejection report';
$string['removeallglossarytags'] = 'All glossary tags';
$string['resetglossaries'] = 'Delete entries from';
$string['resetglossariesall'] = 'Entries from all glossaries';
$string['rssarticles'] = 'Number of RSS recent articles';
$string['rssarticles_help'] = 'This setting specifies the number of glossary entry concepts to include in the RSS feed. Between 5 and 20 generally acceptable.';
$string['rsssubscriberss'] = 'Display the RSS feed for \'{$a}\' concepts';
$string['rssfeed'] = 'RSS feed';
$string['rsstype'] = 'RSS feed for this activity';
$string['rsstype_help'] = 'To enable the RSS feed for this activity, select either concepts with author or concepts without author to be included in the feed.';
$string['search:activity'] = 'Glossary - activity information';
$string['search:entry'] = 'Glossary - entries';
$string['searchindefinition'] = 'Search full text';
$string['secondaryglossary'] = 'Secondary glossary';
$string['showall'] = 'Show \'ALL\' link';
$string['showall_help'] = 'If enabled, participants can browse all entries at once.';
$string['showalphabet'] = 'Show alphabet links';
$string['showalphabet_help'] = 'If enabled, participants can browse the glossary by letters of the alphabet.';
$string['showspecial'] = 'Show \'Special\' link';
$string['showspecial_help'] = 'If enabled, participants can browse the glossary by special characters, such as @ and #.';
$string['sortby'] = 'Sort by';
$string['sortbycreation'] = 'By creation date';
$string['sortbylastupdate'] = 'By last update';
$string['sortchronogically'] = 'Sort chronologically';
$string['special'] = 'Special';
$string['standardview'] = 'Browse by alphabet';
$string['studentcanpost'] = 'Students can add entries';
$string['tagarea_glossary_entries'] = 'Glossary entries';
$string['totalentries'] = 'Total entries';
$string['usedynalink'] = 'Automatically link glossary entries';
$string['usedynalink_help'] = 'If site-wide glossary auto-linking has been enabled by an administrator and this setting is enabled, the "Add a new entry" form includes the option to automatically link the entry wherever the concept words and phrases appear throughout the rest of the course.';
$string['visibletabs'] = 'Visible tabs';
$string['warningstudentcapost'] = '(Applies only if the glossary is not the main one)';
$string['withauthor'] = 'Concepts with author';
$string['withoutauthor'] = 'Concepts without author';
$string['writtenby'] = 'by';
$string['youarenottheauthor'] = 'You are not the author of this comment, so you are not allowed to edit it.';

// Deprecated since 4.3.
$string['completionentriesgroup'] = 'Require entries';

// Deprecated since 4.5.
$string['tagsdeleted'] = 'Glossary tags have been deleted';
